/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.worldgen;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import tictim.paraglider.contents.ModStructures;
import tictim.paraglider.contents.worldgen.BaseHornedStatuePiece;

public class UndergroundHornedStatue
extends StructureFeature<NoneFeatureConfiguration> {
    public UndergroundHornedStatue() {
        super(NoneFeatureConfiguration.f_67815_, PieceGeneratorSupplier.m_197349_(c -> true, UndergroundHornedStatue::generatePieces));
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
        WorldgenRandom rng = context.f_192708_();
        BlockPos pos = new BlockPos(context.f_192705_().m_45604_() + 5 + rng.nextInt(6), 90, context.f_192705_().m_45605_() + 5 + rng.nextInt(6));
        Rotation rotation = Rotation.m_55956_((Random)rng);
        UndergroundHornedStatue.addPieces(context.f_192704_(), pos, rotation, (StructurePieceAccessor)builder);
    }

    public static void addPieces(StructureManager structureManager, BlockPos pos, Rotation rotation, StructurePieceAccessor pieces) {
        pieces.m_142679_((StructurePiece)new Piece(structureManager, rotation, pos));
    }

    public static StructurePieceType.StructureTemplateType pieceType() {
        return Piece::new;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    public static class Piece
    extends BaseHornedStatuePiece {
        private static final ResourceLocation TEMPLATE = new ResourceLocation("paraglider", "underground_horned_statue");

        public Piece(StructureManager structureManager, Rotation rotation, BlockPos templatePos) {
            super(ModStructures.UNDERGROUND_HORNED_STATUE_PIECE_TYPE, structureManager, TEMPLATE, rotation, templatePos);
        }

        public Piece(StructureManager structureManager, CompoundTag tag) {
            super(ModStructures.UNDERGROUND_HORNED_STATUE_PIECE_TYPE, structureManager, tag);
        }

        public void m_183269_(WorldGenLevel level, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            BlockPos pos2 = this.f_73658_.m_141952_((Vec3i)StructureTemplate.m_74563_((StructurePlaceSettings)this.f_73657_, (BlockPos)BlockPos.f_121853_));
            int height = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos2.m_123341_(), pos2.m_123343_());
            this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), height - (random.nextInt(30) + 15), this.f_73658_.m_123343_());
            super.m_183269_(level, structureFeatureManager, chunkGenerator, random, box, chunkPos, pos);
        }

        public NoiseEffect m_142318_() {
            return NoiseEffect.NONE;
        }
    }
}

